ManualCleanEvent = {}
local ManualCleanEvent_mt = Class(ManualCleanEvent, Event)

InitEventClass(ManualCleanEvent, "ManualCleanEvent")

function ManualCleanEvent.emptyNew()
	return Event.new(ManualCleanEvent_mt)
end
---@class ManualCleanEvent
function ManualCleanEvent.new(cleanType, userId)
  fcDebug("ManualCleanEvent-new")
	local self = ManualCleanEvent.emptyNew()
  self.cleanType = cleanType
  self.userId = userId
	return self
end

function ManualCleanEvent:readStream(streamId, connection)
  -- Get data from clients
  self.cleanType = streamReadString(streamId)
  self.userId = User.streamReadUserId(streamId)
	self:run(connection)
end

function ManualCleanEvent:writeStream(streamId, connection)
  -- Send data out to clients
  streamWriteString(streamId, self.cleanType)
  User.streamWriteUserId(streamId, self.userId)
end

function ManualCleanEvent:run(connection)
  fcDebug("ManualCleanEvent-run")
  if self.cleanType ~= nil then
      local totalRemoved = 0
      if self.cleanType == "pallets" then
          -- Run pallet cleanup process
          totalRemoved = g_farmCleanup:cleanPalletsManual()
      elseif self.cleanType == "bales" then
          -- Run bale cleanup process
          totalRemoved = g_farmCleanup:cleanBalesManual()
      elseif self.cleanType == "logs" then
          -- Run log clean up
          totalRemoved = g_farmCleanup:cleanLogs()
      elseif self.cleanType == "stumps" then
          -- Run stump clean up
          totalRemoved = g_farmCleanup:cleanStumps()
      end
      HideMessageDialogEvent.sendEvent(self.userId)
      ShowDialogEvent.sendEvent(self.userId,string.format(g_i18n:getText("info_cleanSuccess"),totalRemoved,self.cleanType),DialogElement.TYPE_INFO)
  end
end

function ManualCleanEvent.sendEvent(cleanType, userId)
  fcDebug("ManualCleanEvent-sendEvent")
  fcDebug(userId)
  if g_currentMission.missionDynamicInfo.isMultiplayer then
      if g_server ~= nil then
          g_server:broadcastEvent(ManualCleanEvent.new(cleanType, userId))
      else
          g_client:getServerConnection():sendEvent(ManualCleanEvent.new(cleanType, userId))
      end
  else
      if cleanType ~= nil then
          local totalRemoved = 0
          if cleanType == "pallets" then
              -- Run pallet cleanup process
              totalRemoved = g_farmCleanup:cleanPalletsManual()
          elseif cleanType == "bales" then
              -- Run bale cleanup process
              totalRemoved = g_farmCleanup:cleanBalesManual()
          elseif cleanType == "logs" then
              -- Run log clean up
              totalRemoved = g_farmCleanup:cleanLogs()
          elseif cleanType == "stumps" then
              -- Run stump clean up
              totalRemoved = g_farmCleanup:cleanStumps()
          end
          HideMessageDialogEvent.sendEvent(userId)
          ShowDialogEvent.sendEvent(userId,string.format(g_i18n:getText("info_cleanSuccess"),totalRemoved,cleanType),DialogElement.TYPE_INFO)
      end
  end
end