SpecialOffers = {}
SpecialOffers.knownSales = {}
SpecialOffers.brandTitleCache = {}
SpecialOffers.vehicleItemCache = {}
SpecialOffers.isFirstRun = true
SpecialOffers.isPlayerWakeUpFromSleep = false
SpecialOffers.isDebugMode = false
SpecialOffers.infoToShown = {}
SpecialOffers.isInfoToShown = false

function debugMsg(debugMessage)
    if SpecialOffers.isDebugMode ~= nil and SpecialOffers.isDebugMode then
        print("[SpecialOffers] --> " .. debugMessage)
    end
end

function SpecialOffers:update(dt)
    if SpecialOffers.isFirstRun == true then
        SpecialOffers.isFirstRun = false
        checkForSales(true)
    end
    if SpecialOffers.isPlayerWakeUpFromSleep == true and g_sleepManager.isSleeping == false then
        SpecialOffers.isPlayerWakeUpFromSleep = false
        checkForSales(false)
    end
    showSpecialOffersInfo()
end

function showSpecialOffersInfo()
    if g_gui.currentGuiName == "" and SpecialOffers.isInfoToShown then
        for x in SpecialOffers.infoToShown do
            if SpecialOffers.infoToShown[x] ~= nil then
                g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, SpecialOffers.infoToShown[x])
            else
                break
            end
        end
        SpecialOffers.isInfoToShown = false
        SpecialOffers.infoToShown = {}
    else
        return
    end
end

function checkForRun(isHour)
    if g_sleepManager.isSleeping == true then
        if not isHour then
            do return end
        elseif SpecialOffers.isPlayerWakeUpFromSleep == true then
            do return end
        elseif isHour then
            SpecialOffers.isPlayerWakeUpFromSleep = true
            do return end
        end
    end
    if isHour then
        checkForSales(false)
    end
end

function getBrandFromRaw(brandRaw)
    if SpecialOffers.brandTitleCache[brandRaw] ~= nil then
        return SpecialOffers.brandTitleCache[brandRaw]
    else
        for brandIndex, brandItem in pairs(g_brandManager.indexToBrand) do
            if brandItem ~= nil then
                if brandItem.name == brandRaw then
                    SpecialOffers.brandTitleCache[brandRaw] = brandItem.title
                    return brandItem.title
                end
            else
                break
            end
        end
        local errorBrand = "(error_b)"
        SpecialOffers.brandTitleCache[brandRaw] = errorBrand
        return errorBrand
    end
end

function cacheVehicle(saleItemXml)
    SpecialOffers.vehicleItemCache[saleItemXml] = {}
    for index, item in pairs(g_storeManager.items) do
        if item ~= nil then
            if item.xmlFilename == saleItemXml then
                SpecialOffers.vehicleItemCache[saleItemXml].itemBrand = getBrandFromRaw(item.brandNameRaw)
                if item.name ~= nil then
                    SpecialOffers.vehicleItemCache[saleItemXml].itemName = item.name
                else
                    SpecialOffers.vehicleItemCache[saleItemXml].itemName = "(error_n)"
                end
                break
            end
        end
    end
    return
end

function checkForSales(isFirstCheckRun)
    local currentSales = {}
    local saleID = ""
    local vehicleCounter = 1
    local saleItemXml = ""
    while g_currentMission.vehicleSaleSystem.items[vehicleCounter] ~= nil do
        saleItemXml = g_currentMission.vehicleSaleSystem.items[vehicleCounter].xmlFilename
        if SpecialOffers.vehicleItemCache[saleItemXml] == nil then cacheVehicle(saleItemXml) end
        if g_currentMission.vehicleSaleSystem.items[vehicleCounter].price ~= nil and g_currentMission.vehicleSaleSystem.items[vehicleCounter].age ~= nil and g_currentMission.vehicleSaleSystem.items[vehicleCounter].xmlFilename ~= nil and SpecialOffers.vehicleItemCache[saleItemXml].itemBrand ~= nil and SpecialOffers.vehicleItemCache[saleItemXml].itemName ~= nil then
            saleID = g_currentMission.vehicleSaleSystem.items[vehicleCounter].price .. g_currentMission.vehicleSaleSystem.items[vehicleCounter].age .. g_currentMission.vehicleSaleSystem.items[vehicleCounter].xmlFilename .. ";" .. SpecialOffers.vehicleItemCache[saleItemXml].itemBrand .. " " .. SpecialOffers.vehicleItemCache[saleItemXml].itemName
            table.insert(currentSales, saleID)
            vehicleCounter = vehicleCounter + 1
        end
    end
    local saleIsKnown = false
    for n in pairs(SpecialOffers.knownSales) do
        for w in pairs(currentSales) do
            if SpecialOffers.knownSales[n] == currentSales[w] then
                saleIsKnown = true
                break
            end
        end
        if saleIsKnown == false then
            table.remove(SpecialOffers.knownSales,n)
        end
        saleIsKnown = false
    end
    for z in pairs(currentSales) do
        saleIsKnown = false
        for w in pairs(SpecialOffers.knownSales) do
             if currentSales[z] == SpecialOffers.knownSales[w] then
                saleIsKnown = true
                break
             end
        end
        if saleIsKnown == false then
            table.insert(SpecialOffers.knownSales, currentSales[z])
            local splitSaleID = {}
            for w in (currentSales[z] .. ";"):gmatch("([^;]*);") do
                table.insert(splitSaleID, w)
            end
            if isFirstCheckRun then
                table.insert(SpecialOffers.infoToShown, string.format(g_i18n:getText("specialoffers_offer"), splitSaleID[2]))
            else
                table.insert(SpecialOffers.infoToShown, string.format(g_i18n:getText("specialoffers_newoffer"), splitSaleID[2]))
            end
            SpecialOffers.isInfoToShown = true
        end
    end
    return
end

function SpecialOffers:hourChanged()
    checkForRun(true)
end

g_messageCenter:subscribe(MessageType.HOUR_CHANGED, SpecialOffers.hourChanged)
addModEventListener(SpecialOffers)